import json
import logging

log = logging.getLogger('flask-backend')

'''
Reads from a JSON File provided. 
If file doesn't exist, raises a FileNotFoundError.
If file exists but is empty, returns an empty dictionary.
@param filePath: string containing the full path of the JSON file to read
'''
def readFromJSONFile(filePath):
    try:
        jsonContent = {}
        with open(filePath) as f:
            contents = f.read()
            if contents != "":
                jsonContent = json.loads(contents)
    except Exception as e:
        log.error("Error reading JSON file {} : {}".format(filePath, e))
        raise e
    else:
        return jsonContent

'''
@param filePath: string containing the full path of the JSON file to write
@param payloadJSON: dictionary containing the data to write into the file
'''
def writeToJSONFile(filePath, payloadJSON):
    try:
        with open(filePath, 'w') as outfile:
            json.dump(payloadJSON, outfile)
    except Exception as e:
        log.error(e)