import logging
import os
import shlex
import subprocess
from datetime import datetime

log = logging.getLogger('flask-backend')

from .system_info import getLogLines, getMACaddr


def writeInConfigLog(log_name, message):
    config_log = logging.getLogger(log_name)
    config_log.info(message)


def getHumanReadableStringFromValue(uci_to_label_map, config, section, option, value):
    if "accepted_values" in uci_to_label_map[config][section][option]:
        status = lambda x: f"enabled" if x else f"disabled"
        if isinstance(uci_to_label_map[config][section][option]["accepted_values"][value], bool):
            stringValue = '"' + status(uci_to_label_map[config][section][option]["accepted_values"][value]) + '"'
        else:
            stringValue = '"' + uci_to_label_map[config][section][option]["accepted_values"][value] + '"'
    elif uci_to_label_map[config][section][option]["value_type"] == "boolean":
        status = lambda x: f"enabled" if x == 'true' else f"disabled" if x == 'false' else f""
        stringValue = '"' + status(value) + '"'
    else:
        # TODO: consider json and (maybe) passwords
        stringValue = '"' + value + '"'
    return stringValue


def writeUciChangeInConfigLog(uci_to_label_map, log_name, config, section, option, prev_value, new_value):
    # build message to write in log
    if config in uci_to_label_map and section in uci_to_label_map[config] and option in uci_to_label_map[config][
        section] and "label" in \
            uci_to_label_map[config][section][option]:
        # add uci label to log message
        message = uci_to_label_map[config][section][option]["label"] + ' changed'
        if prev_value is not None:
            # add previous value to log message
            message += ' from ' + getHumanReadableStringFromValue(uci_to_label_map, config, section, option,
                                                                  prev_value)

        # add new value to log message
        message += ' to ' + getHumanReadableStringFromValue(uci_to_label_map, config, section, option,
                                                            new_value)
        # write in log file
        writeInConfigLog(log_name, message)


def getConfigLogLines(filePath, nLines):
    return getLogLines(filePath, nLines)


def downloadConfigChangesLogs(dirPath):
    macAddr = getMACaddr()
    filename = macAddr + "_config_changes_logs.tar.gz"

    # remove any previous log.tar.gaz that may exist
    try:
        my_dir = '/mnt/data/'  # enter the dir name
        for fname in os.listdir(my_dir):
            if fname.startswith((macAddr + "_").replace(' ', '_')):
                os.remove(os.path.join(my_dir, fname))
    except Exception as e:
        log.error(e)
        raise e

    try:
        cmd = "tar -czf " + my_dir + filename + " -C " + dirPath + " ."
        log.debug(cmd)
        proc = subprocess.run(shlex.split(cmd))
        log.debug(proc.returncode)
    except Exception as e:
        log.error(e)
        raise e

    return my_dir, filename
