import smbus

class I2C:    
    def __init__(self, i2c_bus, chip_address):
        self.chip_address = chip_address
        self.bus = smbus.SMBus(i2c_bus)
    
    def readByte(self, register):
        val = self.bus.read_byte_data(self.chip_address,register)
        return val
    
    def writeByte(self, register, value):
        self.bus.write_byte_data(self.chip_address,register,value)