from BARP.barp_header import BARP_header
from BARP.control_message import *


class BARP:
    def __init__(self, my_id, app_type=""):
        self.my_id = my_id
        self.header_idx = slice(34)
        self.message_idx = slice(34, 4096, 1)
        self.barp_header = BARP_header(app_type)
        self.msg_1 = MSG_1(my_id)
        self.msg_0 = MSG_0(my_id)
        self.msg_2 = MSG_2(my_id)
        self.msg_3 = MSG_3(my_id)
        self.msg_4 = MSG_4(my_id)
        self.msg_5 = MSG_5(my_id)
        self.msg_6 = MSG_6(my_id)
        self.msg_7 = MSG_7(my_id)
        self.msg_8 = MSG_8(my_id)
        self.msg_128 = MSG_128(my_id)
        self.msg_129 = MSG_129(my_id)
        self.msg_130 = MSG_130(my_id)

    def get_message_class(self, message_id):
        if message_id == 1:
            return self.msg_1
        elif message_id == 2:
            return self.msg_2
        elif message_id == 3:
            return self.msg_3
        elif message_id == 4:
            return self.msg_4
        elif message_id == 5:
            return self.msg_5
        elif message_id == 6:
            return self.msg_6
        elif message_id == 7:
            return self.msg_7
        elif message_id == 8:
            return self.msg_8
        elif message_id == 128:
            return self.msg_128
        elif message_id == 129:
            return self.msg_129
        elif message_id == 130:
            return self.msg_130
        else:
            self.msg_0
            print("{} not implemented".format(message_id))

    def decode(self, message):
        """Decodes header and message content according to barp specificaton

        Args:
            message (str): barp message with header, should contain atleast 34 elem.

        Returns:
            Tuple[dict, dict]: header and message.
        """
        header = self.barp_header.decode(message[self.header_idx])
        message_decoder = self.get_message_class(header["message_type"])
        message = message_decoder.decode(message[self.message_idx])
        return header, message

    def encode(
        self,
        message_type,
        flags,
        sender_id,
        receiver_id,
        sequence_number,
        message_kwargs,
        device_type=0,
        station_name="unassigned",
    ):
        """Encodes message and warp in BARP specified format.I

        Args:
            message_type (int): Not larger than 255
            flags (int): Not larger than 65,535
            sender_id (int): Not larger than 65,535
            receiver_id (int): Not larger than 65,535
            sequence_number (int): Not larger than 65,535
            message_kwargs (dict): This dict is passed as kwargs to message encoder

        Returns:
            byte array: packed byte array BARP header + message to be sent
                as udp packet.
        """
        header = self.barp_header.encode(
            message_type,
            flags,
            sender_id,
            receiver_id,
            sequence_number,
            device_type,
            station_name,
        )

        message_encoder = self.get_message_class(message_type)
        message = message_encoder.encode(**message_kwargs)
        return header + message if message is not None else header
