import json
import logging
from flask import Blueprint, Response

from barix.web.auth import login_required
from barix.web.reboot import reboot
from barix.web.exceptions import FwUpdateRunningError

logger = logging.getLogger('flask-backend')

bp = Blueprint('reboot_API', __name__)

@bp.route('/api/rest/v1/reboot', methods=['POST'])
@login_required
def handleRebootRequest():
    try:
        reboot()
    except FwUpdateRunningError as e:
        return Response(json.dumps(e), status=409)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    else:
        return Response(status=200)
