from dataclasses import dataclass
from enum import IntEnum


class AudioControllerState(IntEnum):
    IDLE = 0
    PAGING = 1
    PLAYING_FILE = 2
    RECORDING = 3
    STARTING = 4

    def __str__(self):
        return f'{self.name}'


@dataclass(frozen=True)
class Constants:
    """
        This class contains constants and their values cannot be modified
    """

    # This is currently not used
    ACCESS = {
        'web': 0,
        'user': 1,
        'admin': 2,
        'modbus': 5
    }

    IDLE = 0
    BUSY = 1

    NO = 0
    YES = 1

    FILE_PATH = '/mnt/data/prerecorded_messages/'
    PROCESSED_FILES_PATH = FILE_PATH + 'processed/'
    DEFAULT_FILES_PATH = FILE_PATH + 'default/'
    DEFAULT_FILE_NAME = "default.mp3"  # This file name will be used to create the button
    PYTHON_FILES_DIR = "/barix/apps/icpgw/"
    BACKUP_FILES_LOCATION = '/mnt/data/config/icpgw_config/'
    AUDIO_FILES_BACKUP = ""

    IF_CONFIG_PATH = '/var/tmp/'
    IF_CONFIG_FILE = 'ifconfig.settings'
    PACKETS_NUMBER = 10
    Q_SIZE = 10

    BACKUP_JSON_USERS = PYTHON_FILES_DIR + 'users_backup.json'
    BACKUP_JSON_AUDIO = PYTHON_FILES_DIR + 'audio_files_backup.json'
    BACKUP_JSON_GROUPS = PYTHON_FILES_DIR + 'groups_backup.json'

    # Use the BARPProtocol enum instead
    # COMMAND_START_PAGING = 3
    # COMMAND_STOP_PAGING = 8
