from flask import Flask

import logging
from logging.handlers import RotatingFileHandler

from MainController import MainController
from PagingAPI import PagingAPI
from ModbusAPI import ModbusAPI

import subprocess

# TODO - change log level on release

rotHandler = RotatingFileHandler('/var/log/icpgw.log', maxBytes=2*1024*1024, backupCount=1)
logging.basicConfig(
    level=logging.DEBUG,
    handlers=[rotHandler], 
    format='%(asctime)s [%(levelname)-7s] %(filename)26s:%(lineno)3s %(threadName)18s | %(message)s'
)
logger = logging.getLogger(__name__)

def show_routes(app):
    logger.debug("Available Endpoints:")
    for rule in app.url_map.iter_rules():
        methods = ','.join(rule.methods)
        logger.debug(f"{rule.rule:40s} [{methods+']':35} - {rule.endpoint}")


logger.info("Starting ICPGW...")


logger.info("Checking license...")
result = subprocess.run("qiba-check-license core-image-barix-icpgw -p /mnt/shadow/license-publickey.pem", shell=True)

if result.returncode:

    result = subprocess.run("qiba-check-license barix-development-platform -p /mnt/shadow/license-publickey.pem", shell=True)
    if result.returncode:
        logger.error("Invalid license")
        exit(1)
    logger.warning("Using development license")
else:
    logger.info("Valid license")



main_controller = MainController()
paging_api = PagingAPI(main_controller)
modbus_api = ModbusAPI(main_controller)

app = Flask(__name__, static_folder=None)

app.register_blueprint(paging_api.blueprint, url_prefix='/api/paging/v1/')
app.register_blueprint(modbus_api.blueprint, url_prefix='/api/modbus/v1/')

show_routes(app)

if __name__ == "__main__":
    app.run(host='127.0.0.1', port=4000)
