import json
import logging

from flask import Blueprint, request, Response

from barix.web.auth import login_required
from barix.web.uci import getAllConfigs, getValueOfUci

bp = Blueprint('uci_API', __name__)

logger = logging.getLogger('flask-backend')

@bp.route('/api/rest/v1/ucis', methods=['GET'])
@login_required
def getuci():
    try:
        uciValues = {}
        uciList = request.args

        if uciList == {}:
            logger.info("Request list is empty, getting all UCIs")
            uciList = getAllConfigs()

        logger.info("Getting value of ucis: {}".format(uciList))

        for uciPath in uciList:
            path_params = uciPath.split('.')
            if len(path_params) == 3:
                result = getValueOfUci(path_params[0], path_params[1], path_params[2])
            elif len(path_params) == 2:
                result = getValueOfUci(path_params[0], path_params[1])
            else:
                result = getValueOfUci(path_params[0])
            uciValues[uciPath] = result
        logger.info("Returning uci values: {}".format(uciValues))
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    else:
        return Response(json.dumps(uciValues), status=200)