import logging
import json
import os

from flask import Blueprint, request, Response

from barix.web.auth import login_required
from barix.web.system_info import getSystemInfo, getHWTypeID

bp = Blueprint('system_info_API', __name__)

logger = logging.getLogger('flask-backend')

@bp.route('/api/rest/v1/system/info', methods=['GET'])
@login_required
def handleGetSystemInfo():
    result_dict = {}
    try:
        result_dict = getSystemInfo(request.args)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    logger.debug("Returning system info: {}".format(result_dict))
    return Response(json.dumps(result_dict), status=200)

@bp.route('/api/rest/v1/system/type', methods=['GET'])
@login_required
def getSystemType():
    return_msg = {}

    try:
        return_msg['HW_type_ID'] = getHWTypeID()

        if os.path.exists('/etc/barix/ussi/BARIX_USSI.json'):
            return_msg['hasSNMPSettings'] = True

        if os.path.exists('/tmp/poe-detect'):
            return_msg['hasPoESettings'] = True

        if os.path.exists('/tmp/temp_sensor'):
            return_msg['hasTempSensor'] = True
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)

    logger.debug("Returning system type: {}".format(return_msg))
    return Response(json.dumps(return_msg), status=200)