import logging
import os
import subprocess

from barix.web.certificates import generateSSLCerts
from barix.web.auth import generateNewSessionKey
from barix.web.uci import getValueOfUci

logger = logging.getLogger('flask-backend')


def createListOfServicesToRestart(ucis_list):

    # perform aditional actions before restarting services
    checkIfWebProtocolChanged(ucis_list)

    #create list of services
    servicesToRestart = []
    for uci in ucis_list:
        try:
            config = uci[0]
            section = uci[1]
            option = uci[2]
            if config == "application":
                if section == "audio" and option == "volume":
                    servicesToRestart.append("{}.{}.{}".format(config, section, option))
            elif config == "device":
                #logger.debug("Changes on device uci config do not require do restart any service")
                pass
            elif config == "dropbear":
                if section == "RunCtl" and option == "enable":
                    servicesToRestart.append("dropbear")
            elif config == "flexa_agent":
                pass
            elif config == "flexa_app":
                #    listOfServicesToRestart.append("S92flexa_app")
                pass
            elif config == "httpd":
                section = uci[1]
                option = uci[2]
                if section == "webserver":
                    if option == "protocol":
                        # restart nginx
                        servicesToRestart.append("nginx")
                    if option == "session_timeout":
                        servicesToRestart.append("webui")  # restart backend from new_webui
            elif config == "icpgw":
                servicesToRestart.append("icpgw_main_app")
                section = uci[1]
                if section == "modbus" or section == "pregong":
                    restartModbus()
            elif config == "network":
                servicesToRestart.append('reboot')
            elif config == "ntp":
                servicesToRestart.append("S20ntpd")
            elif config == "security":
                # logger.debug("Changes on security uci config do not require do restart any service")
                pass
            elif config == "sonic_ip":
                # logger.debug("Changes on sonic_ip uci config do not require do restart any service")
                #listOfServices.append("S13sonic-ip")
                pass
            elif config == "syslogd":
                pass
            elif config == "timezone":
                servicesToRestart.append('S20timezone-handler')
            else:
                logger.error("Unrecognized UCI config: {}".format(config))
        except Exception as e:
            logger.error(e, exc_info=True)
            raise e

    return servicesToRestart


def checkIfWebProtocolChanged(ucisChanged):
    try:
        # check if web protocol changed to HTTPS
        for uciTuple in ucisChanged:
            if ('httpd', 'webserver', 'protocol') == uciTuple:
                generateNewSessionKey()
                if getValueOfUci('httpd', 'webserver', 'protocol') == 'https':
                    generateSSLCerts()
                break
    except Exception as e:
        raise e


def restartApp():
    logger.info("Restarting icpgw app...")
    command = "/barix/hooks/application/icpgw.hook restart"
    result = subprocess.run(
        command,
        shell=True,
        capture_output=True,  # captures stdout and stderr
        text=True,  # returns strings instead of bytes
        timeout=15
    )

    # Access return code
    return_code = result.returncode

    # If return code is non-zero, print all output (stdout + stderr)
    if return_code != 0:
        output = result.stdout + result.stderr
        raise RuntimeError(
            f"Restarting icpgw app failed with exit code {return_code}:\n{output}"
        )


def restartModbus():
    logger.info("Restarting modbus...")
    command = ["/barix/hooks/application/modbus.hook", "restart"]
    subprocess.run(command, capture_output=True, text=True)


# NGINX_SITES_ENABLED = "/etc/nginx/sites-enabled"
# HTTPS_CONF = os.path.join("/etc/nginx/sites-available/default_server_https")
# HTTP_CONF = os.path.join("/etc/nginx/sites-available/default_server_http")
# DEFAULT_LINK = os.path.join(NGINX_SITES_ENABLED, "default_server")
#
#
# def configureNginx(mode):
#     target_conf = None
#     if mode == "https":
#         target_conf = HTTPS_CONF
#     elif mode == "http":
#         target_conf = HTTP_CONF
#
#         # Create or update the symlink
#     try:
#         if target_conf is not None:
#             if os.path.islink(DEFAULT_LINK) or os.path.exists(DEFAULT_LINK):
#                 os.remove(DEFAULT_LINK)
#             os.symlink(target_conf, DEFAULT_LINK)
#             logger.info(f"Switched nginx config to {mode.upper()} mode: {DEFAULT_LINK} -> {target_conf}")
#     except Exception as e:
#         logger.error(e, exc_info=True)