import logging
import os

from flask import Blueprint, Response, send_file

from barix.web.auth import login_required
from barix.web.system_info import downloadAllSystemLogs, getSystemLogMessages


bp = Blueprint('logs_API', __name__)

logger = logging.getLogger('flask-backend')

@bp.route('/api/rest/v1/logs/system', methods=['GET'])
@login_required
def getSystemLog():
    try:
        log_msgs = getSystemLogMessages()
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    return Response(log_msgs, status=200)


@bp.route('/api/rest/v1/logs', methods=['GET'])
@login_required
def downloadAllLogs():
    try:
        filename = downloadAllSystemLogs()
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    else:
        return send_file(
            os.path.join('/mnt/data', filename),
            as_attachment=True,
            download_name=filename,
            max_age=0
        )
