import logging
from flask import Blueprint, request, jsonify

from MainController import MainController


logger = logging.getLogger(__name__)

class ModbusAPI:
    def __init__(self, main_controller: MainController):
        self._main_controller = main_controller
        self.blueprint = Blueprint('modbus_API', __name__)


        @self.blueprint.route('lock', methods=['POST'])
        def modbus_lock():
            self._main_controller.modbus_lock()
            return "", 200
        
        @self.blueprint.route('unlock', methods=['POST'])
        def modbus_unlock():
            self._main_controller.modbus_unlock()
            return "", 200

        @self.blueprint.route('play-file', methods=['POST'])
        def play_file():
            data = request.json
            return self._main_controller.modbus_play_file(data)

        @self.blueprint.route('stop', methods=['POST'])
        def stop():
            self._main_controller.stop_audio()
            return "", 200

        @self.blueprint.route('status', methods=['GET'])
        def get_status():
            return jsonify({"status": self._main_controller.get_status()}), 200
