import json
import urllib
import time
import threading
from barix import HTTPRequestsAPI
from .uci import getValueOfUci


class DanteApiClient:
    """
    HTTP API REST Client for local Dante service
    """

    def __init__(self, port):
        self.ipaddress = "127.0.0.1"
        self.port = port

    def setVolume(self, vol):
        url = '/api/v1/volume'
        payload = {"volume": vol}
        r = HTTPRequestsAPI.put('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status
