#   Abstract class for Audio Amplifiers
#   I2C access using smbus python module


import abc
from barix.io.I2C import *

class AudioAmp(I2C):

    """ AMP I2C ACCESS """
    
    def __init__(self, i2c_bus, chip_address):
        super(AudioAmp, self).__init__(i2c_bus,chip_address)
    
    """
    ABSTRACT METHODS
    """

    @abc.abstractmethod
    def prepareRegs(self):
        raise NotImplementedError
    
    @abc.abstractmethod
    def resetAmp(self):
        raise NotImplementedError

    @abc.abstractmethod
    def initAmp(self):
        raise NotImplementedError
    
    @abc.abstractmethod
    def powerOnAmp(self):
        raise NotImplementedError

    @abc.abstractmethod
    def setupAmp(self):
        raise NotImplementedError

    @abc.abstractmethod
    def setVol(self, vol):
        """Set amplifier volume to vol"""
        raise NotImplementedError

    @abc.abstractmethod
    def getVol(self):
        """Get amplifier volume"""
        raise NotImplementedError

    @abc.abstractmethod
    def setGain(self, gain):
        """Set amplifier gain"""
        raise NotImplementedError
        
    @abc.abstractmethod
    def getGain(self):
        """Get amplifier gain"""
        raise NotImplementedError
    
    """Specific/Optional methods"""
    
    def readTemp(self):
        """Read amplifier temperature"""
        return "NA"
    
    def getImpedance(self):
        """Get amplifier measured speaker impedance """
        return "NA"

    def getOverTemp(self):
        """Get Over Temperature Warning State"""
        return "NA"

    def checkAmpMode(self):
        """ Check device operational mode """
        return "NA"