import urllib.request
import urllib.error
import ssl
import urllib.parse
import json


def get(url, timeout=None, SSLVerify=True):
    request = urllib.request.Request(url= url, method='GET')
    context = None
    if not SSLVerify:
        context = ssl.create_default_context()
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE
    #TODO: create context to actually validate HTTPS connections?
    if timeout is not None:
        r = urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        r = urllib.request.urlopen(request, context=context)
    return r


# payload should be JSON
def post(url, payload, timeout=None, SSLVerify=True):
    print(payload)
    print(json.dumps(payload).encode('utf-8'))
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='POST')
    request.add_header('Content-Type', 'application/json')
    context = None
    if not SSLVerify:
        context = ssl.create_default_context()
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE
    # TODO: create context to actually validate HTTPS connections?
    if timeout is not None:
        r = urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        r = urllib.request.urlopen(request, context=context)
    return r


def put(url, payload, timeout=None, SSLVerify=False):
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='PUT')
    request.add_header('Content-Type', 'application/json')
    context = None
    if not SSLVerify:
        context = ssl.create_default_context()
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE
    # TODO: create context to actually validate HTTPS connections?
    if timeout is not None:
        r = urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        r = urllib.request.urlopen(request, context=context)
    return r


def delete(url, timeout=None, SSLVerify=False):
    request = urllib.request.Request(url=url, method='DELETE')
    context = None
    if not SSLVerify:
        context = ssl.create_default_context()
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE
    # TODO: create context to actually validate HTTPS connections?
    if timeout is not None:
        r = urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        r = urllib.request.urlopen(request, context=context)
    return r


def patch(url, payload, timeout=None, SSLVerify=False):
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='PATCH')
    request.add_header('Content-Type', 'application/json')
    context = None
    if not SSLVerify:
        context = ssl.create_default_context()
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE
    # TODO: create context to actually validate HTTPS connections?
    if timeout is not None:
        r = urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        r = urllib.request.urlopen(request, context=context)
    return r