#!/bin/sh

source /usr/bin/jshn.sh
export _json_no_warning=1

print_var() {
  if [ ! -z "$1" ]; then echo "$1"; else echo "Undefined";  fi;
}

print_usage() {
  echo "usage: $1"
  echo "Print the specified production info."
  echo ""
  echo "  -i|--product_id              to print the Product ID"
  echo "  -n|--product_name            to print the Product Name"
  echo "  -d|--producton_date          to print the Production Date"
  echo "  -b|--ipam_type               to print the Legacy IPAM type"
  echo "  -c|--ipam_name               to print the IPAM name"
  echo "  -w|--hw_type                 to print the Legacy HW Type"
  echo "  -v|--device_revision         to print the Device HW revision"
  echo "  -t|--test_status             to print the test status"
  echo "  -a|--image_name              to print the image name"
  echo "  -g|--info_sign               to print the production info signature"
  echo "  -e|--error_status            to print the device error status"
  echo "  -h|--help                    to print this help page"
  exit 0
}

getopt --test > /dev/null
if [[ $? -ne 4 ]]; then
    echo "I'm sorry, `getopt --test` failed in this environment."
    exit 1
fi

OPTIONS=indbcwvtafgeh
LONGOPTIONS=product_id,product_name,ipam_type,ipam_name,production_date,hw_type,device_revision,test_status,image_name,image_features,image_sign,error_status,help

# -temporarily store output to be able to check for errors
# -e.g. use "--options" parameter by name to activate quoting/enhanced mode
# -pass arguments only via   -- "$@"   to separate them correctly
PARSED=$(getopt --options=$OPTIONS --longoptions=$LONGOPTIONS --name "$0" -- "$@")
if [[ $? -ne 0 ]]; then
    # e.g. $? == 1
    #  then getopt has complained about wrong arguments to stdout
    exit 2
fi
# read getopt's output this way to handle the quoting right:
eval set -- "$PARSED"

# now enjoy the options in order and nicely split until we see --
while true; do
    case "$1" in
        -i|--product_id)
            PRODUCT_ID="y"
            shift
            ;;
        -n|--product_name)
            PRODUCT_NAME="y"
            shift
            ;;
        -d|--production_date)
            PRODUCT_DATE="y"
            shift
            ;;
        -w|--hw_type)
            HW_TYPE="y"
            shift
            ;;
        -v|--device_hw)
            DEVICE_REVISION="y"
            shift
            ;;
        -b|--ipam_type)
            IPAM_TYPE="y"
            shift
            ;;
        -c|--ipam_name)
            IPAM_NAME="y"
            shift
            ;;
        -t|--test_status)
            TEST_STATUS="y"
            shift
            ;;
        -a|--image_name)
            IMAGE_NAME="y"
            shift
            ;;
        -g|--info_sign)
            INFO_SIGN="y"
            shift
            ;;
        -e|--error-status)
            ERROR_STATUS="y"
            shift
            ;;
        -h|--help)
            print_usage $0
            exit 1
            ;;
        --)
            shift
            break
            ;;
        *)
            echo "Programming error"
            exit 3
            ;;
    esac
done

HW_INFO=`qiba-spi-get-info`
json_load "$HW_INFO"

if [ ! -z $PRODUCT_ID ]; then
  json_select HW_DEVICE
  json_get_var PRODUCT_ID "Product_ID"
  print_var "$PRODUCT_ID"
fi

if [ ! -z $PRODUCT_NAME ]; then
  json_select HW_DEVICE
  json_get_var PRODUCT_NAME "Product_Name"
  print_var "$PRODUCT_NAME"
fi

if [ ! -z $PRODUCT_DATE ]; then
  json_select HW_DEVICE
  json_get_var PRODUCT_DATE "Production_Date"
  print_var "$PRODUCT_DATE"
fi

if [ ! -z $IPAM_TYPE ]; then
  json_select HW_DEVICE
  json_get_var IPAM_TYPE "Legacy_IPAM_Type"
  print_var "$IPAM_TYPE"
fi

if [ ! -z $IPAM_NAME ]; then
  json_select HW_DEVICE
  json_get_var IPAM_NAME "IPAM_Name"
  print_var "$IPAM_NAME"
fi

if [ ! -z $HW_TYPE ]; then
  json_select HW_DEVICE
  json_get_var HW_TYPE "Legacy_HW_Type"
  print_var "$HW_TYPE"
fi

if [ ! -z $DEVICE_REVISION ]; then
  json_select HW_DEVICE
  json_get_var DEVICE_REVISION "Device_Revision"
  print_var "$DEVICE_REVISION"
fi

if [ ! -z $ERROR_STATUS ]; then
  json_select HW_DEVICE
  json_get_var ERROR_STATUS "Error_Status"
  print_var "$ERROR_STATUS"
fi

if [ ! -z $INFO_SIGN ]; then
  json_select HW_DEVICE
  json_get_var INFO_SIGN "Signature"
  print_var "$INFO_SIGN"
fi

if [ ! -z $TEST_STATUS ]; then
  json_select HW_TEST
  json_get_var TEST_STATUS "Status"
  print_var "$TEST_STATUS"
fi

if [ ! -z $IMAGE_NAME ]; then
  json_select IMAGE
  json_get_var IMAGE_NAME "Name"
  print_var "$IMAGE_NAME"
fi

#nothing to do
exit 1
