import logging
from flask import Blueprint, Response

from barix.web.auth import login_required
from barix.web.reset_to_defaults import resetToDefaults

logger = logging.getLogger('flask-backend')

bp = Blueprint('defaults_API', __name__)

@bp.route('/api/rest/v1/defaults', methods=['POST'])
@login_required
def handleResetToDefaultsRequest():
    try:
        resetToDefaults()
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)
    else:
        return Response(status=200)
