import json
import logging
import os

import requests
from flask import Blueprint, Response, request

from barix.web.auth import login_required

from groups import get_groups, new_group, update_group, remove_groups

bp = Blueprint('groups_API', __name__)

logger = logging.getLogger('flask-backend')


@bp.route('/api/rest/v1/groups', methods=['GET'])
@login_required
def get_all_groups():
    try:
        data = get_groups()

        # transform dict into array
        groupsList = [
            {"id": key, **value} for key, value in data.items()
        ]

        return Response(json.dumps({"groups": groupsList}), status=200)

    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/groups', methods=['POST'])
@login_required
def add_group():
    try:
        group_id, reason = new_group(request.json)
        if group_id is not None:
            if reason == "":
                return Response(json.dumps({"id": group_id}), status=201, headers={"Content-Type": "application/json"})
            else:
                return Response(reason, status=400)
        else:
            return Response("The maximum group limit has been reached", status=409)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/groups', methods=['PUT'])
@login_required
def edit_group():
    try:
        update_successful, reason = update_group(request.json)
        if update_successful:
            return Response(status=200)
        else:
            if "not found" in reason:
                return Response(reason, status=404)
            else:
                return Response(reason, status=400)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/groups', methods=['DELETE'])
@login_required
def delete_groups():
    try:
        groups_not_removed = remove_groups(request.json)
        return Response(json.dumps({"groups_not_removed": groups_not_removed}), status=200)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)