import json
import logging

from flask import Blueprint, request, Response
from barix.web.exceptions import InvalidUploadedFileError, FwUpdateRunningError, FileTooLargeError
from barix.web.fw_update import updateFirmware, getFwUpdateStatus, startFwUpdate, stopFwImageUpload
from barix.web.auth import login_required

logger = logging.getLogger('flask-backend')

bp = Blueprint('fw_update_API', __name__)

@bp.route('/api/rest/v1/system/update', methods=['POST'])
@login_required
def handleFWImageUpdate():
    logger.info('handleFWImageUpdate')
    startFwUpdate()
    try:
        logger.info('updateFirmware')
        updateFirmware(request.files)
    except InvalidUploadedFileError as e:
        logger.error(e, exc_info=True)
        return Response(json.dumps(e), status=400)
    except FwUpdateRunningError:
        return Response(json.dumps('There is already a firmware update running.'), status=409)
    except FileTooLargeError as e:
        logger.error(e, exc_info=True)
        return Response(json.dumps(e), status=413)
    except Exception as e:
        logger.error(e, exc_info=True)
        stopFwImageUpload()
        return Response(status=500)
    else:
        return Response(status=200)

@bp.route('/api/rest/v1/system/update', methods=['GET'])
@login_required
def handleGetFwUpdateStatus():
    updateStatus = getFwUpdateStatus()
    return Response(json.dumps(updateStatus), status=200)

