#
#   Routes to accept in Flask and redirect to frontend
#   Default routes sample
#
from flask import Blueprint, render_template

frontendRoutes = Blueprint('frontendRoutes', __name__, template_folder='static')

@frontendRoutes.route('/')
@frontendRoutes.route('/settings')
@frontendRoutes.route('/paging-settings')
@frontendRoutes.route('/play-audio')
@frontendRoutes.route('/stop-audio')
@frontendRoutes.route('/play-status')
@frontendRoutes.route('/users')
@frontendRoutes.route('/groups')
@frontendRoutes.route('/audio-files')
@frontendRoutes.route('/paging')
@frontendRoutes.route('/paging/settings')
@frontendRoutes.route('/paging/groups')
@frontendRoutes.route('/paging/menu')
@frontendRoutes.route('/paging/device-messages')
@frontendRoutes.route('/system-status')
@frontendRoutes.route('/logs')
@frontendRoutes.route('/defaults')
@frontendRoutes.route('/update')
@frontendRoutes.route('/reboot')
@frontendRoutes.route('/cgi-bin')
@frontendRoutes.route('/login', methods=['GET'])
def basic_pages0(**kwargs):
    return render_template('index.html')

@frontendRoutes.errorhandler(404)
def page_not_found(e):
    # return render_template('404.html'), 404
    return render_template('index.html')
