import json
import logging
from flask import Blueprint, session, request, Response

from barix.web.auth import getSessionKey
from barix.web.webui_password import currPasswordIsValid
from barix.web.uci import getValueOfUci

bp = Blueprint('auth_API', __name__)

logger = logging.getLogger('flask-backend')

@bp.route('/api/rest/v1/login', methods=['POST'])
def login():
    try:
        data = json.loads(request.data)
        username = data['username']
        password = data['password']
        if checkIfUsernameAndPwdAreValid(username, password):
            session['sessionID'] = getSessionKey()
            session.modified = True
            if getValueOfUci('httpd', 'webserver', 'password_set') == "true":
                session.permanent = True
            return Response(status=200)
        else:
            logger.error("Can't login. Invalid username or password!")
            return Response('Invalid username or password', status=401, headers={"Content-Type" : "text/plain"})
    except Exception as e:
        logger.error("Exception during login {}".format(e))
        return Response(status=500)

def checkIfUsernameAndPwdAreValid(username, password):
    try:
        return currPasswordIsValid(password, username=username)
    except Exception as e:
        logger.error(e, exc_info=True)
        return False