import logging
from functools import wraps

from flask import request, json, Response

import os
import sys

PYTHON_FILES_DIR = "/barix/apps/icpgw/"
BACKUP_JSON_USERS = PYTHON_FILES_DIR + 'users_backup.json'

logger = logging.getLogger('flask-backend')

def token_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        token = None
        if 'token' in request.args:
            token = request.args['token']
        if 'token' in request.view_args:
            token = request.view_args['token']
        if token is not None:
            with open(BACKUP_JSON_USERS) as file:
                mydict = json.load(file)
                payload = None
                userValid = False
                statusCode = None
                for key in mydict:
                    if mydict[key]["secret"] == token:
                        userValid = True
                if userValid:
                    return f(*args, **kwargs)
                else:
                    logger.info("User with no permission: {}".format(token))
                    return Response(status=401)
        else:
            logger.info("User with no permission: {}".format(token))
            return Response(status=401)
    return decorated_function
