import json
import logging
from flask import Blueprint, Response, request

from barix.web.auth import login_required

from audio_files import store_pregong_file, get_pregong_file, remove_pregong_file, get_audio_files_info, new_audio_file, \
    update_audio_file, remove_audio_files

bp = Blueprint('audio_files_API', __name__)

logger = logging.getLogger('flask-backend')


@bp.route('/api/rest/v1/audio-files', methods=['GET'])
@login_required
def get_all_audio_files():
    try:
        data = get_audio_files_info()

        # transform dict into array
        audioFilesList = [
            {"id": key, **value} for key, value in data.items()
        ]

        # send list of users in response
        response_json = {"audio-files": audioFilesList}

        return Response(json.dumps(response_json), status=200, headers={"Content-Type": "application/json"})

    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/audio-files', methods=['POST'])
@login_required
def add_audio_file():
    try:
        # Access the 'data' field (which is a JSON string)
        data_str = request.form.get('data')
        if not data_str:
            return "No data field", 400
        request_data = json.loads(data_str)

        msg, status_code = new_audio_file(request.files, request_data)
        return Response(msg, status=status_code)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/audio-files', methods=['PUT'])
@login_required
def edit_audio_file():
    try:
        request_data = json.loads(request.form['data'])

        if 'audio_file' in request.files:
            uploaded_file = request.files['audio_file']
        else:
            uploaded_file = None

        msg, status_code = update_audio_file(request_data, uploaded_file)
        return Response(msg, status=status_code)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/audio-files', methods=['DELETE'])
@login_required
def delete_audio_files():
    try:
        audio_files_not_removed = remove_audio_files(request.json)
        return Response(json.dumps({"audio_files_not_removed": audio_files_not_removed}), status=200)
    except Exception as e:
        logger.error(e, exc_info=True)
        return Response(status=500)


@bp.route('/api/rest/v1/audio-files/pregong', methods=['POST'])
def new_pregong_file():
    msg, status_code = store_pregong_file(request.files)
    return Response(msg, status = status_code)


@bp.route('/api/rest/v1/audio-files/pregong/info', methods=['GET'])
def get_pregong_file_info():
    msg, status_code = get_pregong_file()
    return Response(msg, status=status_code)


@bp.route('/api/rest/v1/audio-files/pregong', methods=['DELETE'])
def delete_pregong_file():
    msg, status_code = remove_pregong_file()
    return Response(msg, status=status_code)