import os
import subprocess
import time
from watchdog.observers import Observer
from watchdog.events import PatternMatchingEventHandler


import logging
logger = logging.getLogger('flask-backend')

# When running on the device
FROM_LOCATION = "/barix/apps/icpgw/"
BACKUP_FILES_LOCATION = "/mnt/data/config/icpgw_config/"

# When running on PC
# BACKUP_FILES_LOCATION = '/home/anton/Desktop/test_backup_files/'
# FROM_LOCATION = '/home/anton/Anton_Projects/ic-paging/backend/'


class BackupSettingsWD:
    """
        Class to detect file changes in a directory and create backup copies.
        Param: pattern for files to match in the given directory
    """

    def __init__(self, pattern):
        self.pattern = pattern
        # import sys
        # path = sys.argv[1] if len(sys.argv) > 1 else '.'
        #self.path = Constants.PYTHON_FILES_DIR if len(Constants.PYTHON_FILES_DIR) > 1 else '.'
        self.path = FROM_LOCATION

        logger.info(f"Barix path: {self.path}")

        ignore_patterns = None
        ignore_directories = False
        case_sensitive = True
        self.event_handler = PatternMatchingEventHandler(self.pattern, ignore_patterns,
                                                         ignore_directories, case_sensitive)

        self.event_handler.on_created = self.on_created
        self.event_handler.on_deleted = self.on_deleted
        self.event_handler.on_modified = self.on_modified
        self.event_handler.on_moved = self.on_moved

        self.observer = Observer()
        self.observer.schedule(self.event_handler, self.path, recursive=True)

        # Check whether the specified path exists or not
        is_exist = os.path.exists(BACKUP_FILES_LOCATION)
        if not is_exist:
            # Create a new directory because it does not exist
            os.makedirs(BACKUP_FILES_LOCATION)
            logger.info(f"The new directory {BACKUP_FILES_LOCATION} was created!")

        logger.info("Initialized...")

    @staticmethod
    def on_created(event):
        logger.info(f"{event.src_path} has been created!")
        logger.warning("No action currently implemented!")

    @staticmethod
    def on_deleted(event):
        logger.warning(f"Deleted {event.src_path}!")
        logger.warning("No action currently implemented!")

    @staticmethod
    def on_moved(event):
        logger.info(f"Moved {event.src_path} to {event.dest_path}")
        logger.warning("No action currently implemented!")

    @staticmethod
    def copy_default_file(from_location, from_file, to_location, to_file):
        """
            A default audio file is stored inside /mnt/data/prerecorded_messages/default to be used as an example.
            The filename in that directory must be default.mp3 in order for it to be processed.
        Returns:

        """

        copy_from = os.path.join(from_location, from_file)
        copy_to = os.path.join(to_location, to_file)

        # logger.info(f"Copy file from: {copy_from}")
        # logger.info(f"Copy file to: {copy_to}")
        # print(f"Copy file from: {copy_from}")
        # print(f"Copy file to: {copy_to}")

        command = [
            "cp",
            copy_from,
            copy_to,
        ]

        process = subprocess.Popen(
            command,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
        )
        try:
            outs, errs = process.communicate(timeout=1)

            logger.debug(f"output: {outs}")
            logger.debug(f"error :{errs}")
            logger.info("Backup successfull!")
            logger.info(f"Backup location: {copy_to}")
            # print("Successful")
        except subprocess.TimeoutExpired:
            process.kill()
            outs, errs = process.communicate()
            logger.warning(f"Timed out, killing processing of {copy_from} : errs :{errs}")
            # print(f"Failed!: errs: {errs}")

    def run(self):
        self.observer.start()
        try:
            while True:
                time.sleep(3)
        except KeyboardInterrupt:
            self.observer.stop()
            logger.warning("Backup WD stopped")
        self.observer.join()

    def on_modified(self, event):
        file_to_copy = event.src_path
        event_list = file_to_copy.split(FROM_LOCATION)
        file_to_copy = event_list[1]

        logger.info(f"{event.src_path} has been modified")
        self.copy_default_file(from_location=FROM_LOCATION, from_file=file_to_copy,
                               to_location=BACKUP_FILES_LOCATION, to_file=file_to_copy)


# if __name__ == "__main__":
#     backup_files = BackupSettingsWD(["*_backup.json"])
#     backup_files.run()


