from barix.io.Gpio import Gpio
import logging
import threading
from enum import Enum


logger = logging.getLogger('flask-backend')

class INPUT_MODE(str, Enum):
    SIP                      = 'SIP'
    SIP_PHR                  = 'SIP_PHR'
    SIP_REFER_BLIND_TRANSFER = 'SIP_REFER_BLIND_TRANSFER'


class SIP_ACTIVATE_RELAY(str, Enum):
    ON_SIP_RINGING          = 'ON_SIP_RINGING'
    ON_SIP_ACTIVE_CALL      = 'ON_SIP_ACTIVE_CALL'
    ON_SIP_DTMF             = 'ON_SIP_DTMF'


class Input:
    IDLE     = 0
    PRESSED  = 1
    RELEASED = 2

    def __init__(self, pin:int):
        self.lock   = threading.Lock()
        self.pin    = pin
        self.gpio   = Gpio(str(pin),Gpio.IN)
        self.state  = self.gpio.read()

    def checkEvents(self) -> int:
        """
        Check for updates on the input
        """
        try:
            with self.lock:
                stt = self.gpio.read()
                if self.state==stt:
                    return Input.IDLE

                self.state  = stt
                if stt==1:
                    return Input.RELEASED
                return Input.PRESSED
        except Exception as e:
            logger.error(f"GPIO{self.pin} Check events: {e}")

    def getState(self):
        if self.state:
            return Input.RELEASED
        return Input.PRESSED

    def read(self) -> int:
        """
        Read the input. Does not update event tracking.
        """
        return self.gpio.read()


class Relay:
    ON  = 1
    OFF = 2

    def __init__(self, pin: int):
        self.lock = threading.Lock()
        self.pin = pin
        self.gpio = Gpio(str(pin), Gpio.OUT, True, True)
        self.state = Relay.OFF

    def getState(self):
        return self.state

    def write(self, value:int):
        try:
            with self.lock:
                self.gpio.write(value)
                if value:
                    self.state = Relay.ON
                else:
                    self.state = Relay.OFF
        except Exception as e:
            logger.error(f"Relay write value {value}: {e}")
