import json
import logging
# import urllib
# import ssl
from flask import Response, send_from_directory, Blueprint, request, abort
from barix.web.uci import getValueOfUci

from MainController import MainController



DOWNLOAD_DIRECTORY = "/mnt/data/prerecorded_messages/"

logger = logging.getLogger(__name__)


def handle_request(controller_method):
    try:
        return controller_method(request.json)
    except Exception as e:
        logger.error(e, exc_info=True)
        return '', 500


class PagingAPI:

    # TODO - this requests should validate token

    def __init__(self, main_controller: MainController):
        self._main_controller = main_controller
        self.blueprint = Blueprint('paging_API', __name__)

        @self.blueprint.route('/settings/username', methods=['GET'])
        def get_user():
            try:
                token = request.args['token']

                logger.info("Received: {} {}".format(request.method, request.full_path))
                payload = None
                statusCode = None

                # users = getUsers()
                users = self._main_controller.users_data
                for key in users:
                    if users[key]["secret"] == token:
                        payload = json.dumps({"name": users[key]["name"]})
                        statusCode = 200
                if payload is None:
                    statusCode = 404

                headers = {'Content-type': 'application/json'}

                return Response(response=payload, status=statusCode, headers=headers)
            except Exception as e:
                logger.error(e, exc_info=True)
                return '', 500

        @self.blueprint.route('/settings/sample-rate', methods=['GET'])
        def get_sample_rate():
            try:
                sample_rate = getValueOfUci('icpgw', 'barp', 'sample_rate')
                headers = {'Content-type': 'application/json'}
                return Response(response=sample_rate, status=200, headers={'Content-type': 'application/json'})
            except Exception as e:
                logger.error(e, exc_info=True)
                return '', 500

        @self.blueprint.route('/settings/device-messages', methods=['GET'])
        def get_all_device_messages():
            try:
                user_audio_files = {}
                # get the ids of the audio_files assigned to the user
                user_audio_file_ids = []
                token = request.args['token']
                # users = getUsers()
                users = self._main_controller.users_data
                isAdmin = False
                for user_id in users:
                    if users[user_id]["secret"] == token:
                        if user_id == "0":  # admin
                            isAdmin = True
                        else:
                            if "audio_files" in users[user_id].keys():
                                user_audio_file_ids = users[user_id]["audio_files"]

                # get audio files information
                if isAdmin or len(user_audio_file_ids) > 0:
                    audio_files = self._main_controller.audio_files
                    # audio_files = getAudioFiles()
                    for key in audio_files:
                        if isAdmin:
                            user_audio_files[key] = audio_files[key]
                        else:
                            if key in user_audio_file_ids:
                                user_audio_files[key] = audio_files[key]

                headers = {'Content-type': 'application/json'}
                return Response(response=json.dumps(user_audio_files), status=200, headers=headers)
            except Exception as e:
                logger.error(e, exc_info=True)
                return '', 500


        @self.blueprint.route('/settings/device-messages/<id>', methods=['GET'])
        def get_device_message_file(id):
            try:
                if id in self._main_controller.audio_files:
                    filename = self._main_controller.audio_files[id]['file_name']
                    return send_from_directory(DOWNLOAD_DIRECTORY, filename, as_attachment=True)
                return "File doesn't exists", 400
            except FileNotFoundError as e:
                logger.error(e, exc_info=True)
                return '', 500


        @self.blueprint.route('/settings/groups', methods=['GET'])
        def get_group():
            try:
                json_payload = self._main_controller.groups_data
                # json_payload = self._main_controller.groups_data.value
                return Response(json.dumps(json_payload), status=200, headers={"Content-Type": "application/json"})
            except Exception as e:
                logger.error(e, exc_info=True)
                return '', 500


###############################################################################
#
# 
#
###############################################################################


        @self.blueprint.route('/play-file', methods=['POST'])
        def play_file():
            data = request.json
            data['token'] = request.args['token']
            msg, ret_val = self._main_controller.check_play_permissions(request.json)
            if ret_val != 200:
                return msg, 409
            
            self._main_controller.play_file(data)

            return "", 204


        @self.blueprint.route('/play-recorded', methods=['POST'])
        def play_recorded():
            data = request.json
            data['token'] = request.args['token']
            msg, ret_val = self._main_controller.check_play_permissions(request.json)
            if ret_val != 200:
                return msg, 409

            self._main_controller.play_recorded(data)
            return "", 204


        @self.blueprint.route('/start-paging', methods=['POST'])
        def start_paging():
            data = request.json
            data['token'] = request.args['token']
            msg, ret_val = self._main_controller.check_play_permissions(request.json)
            if ret_val != 200:
                return msg, 409

            self._main_controller.start_paging(data)
            return "", 204


        @self.blueprint.route('/live-paging', methods=['POST'])
        def live_paging():
            try:
                data = request.json
                data['token'] = request.args['token']
                msg, ret_val = self._main_controller.check_user_permissions(data)
                if ret_val != 200:
                    return msg, 409 
                self._main_controller.page_audio(data)
                return "", 204
            except Exception as e:
                logger.error(e, exc_info=True)
                return "", 500


        @self.blueprint.route('/stop', methods=['POST'])
        def stop():
            try:
                status = self._main_controller.get_status()
                if status == "IDLE":
                    return "", 204

                data = request.json
                data['token'] = request.args['token']
                msg, ret_val = self._main_controller.check_user_permissions(request.json)
                if ret_val != 200:
                    logger.debug(f"stop: <{msg}>")
                    return msg, 409

                self._main_controller.stop_audio()
                return "", 204
            except Exception as e:
                logger.error(e, exc_info=True)
                return "", 500


        @self.blueprint.route('/play-status', methods=['POST'])
        def play_status():
            data = request.json
            data['token'] = request.args['token']
            return self._main_controller.get_playfile_state(request.json)

