local uv = require("luv"); --Install luv
local biudp = require("biudp");

BASE_NODE_PORT = 9233;
INTERFACE_NODE_PORT = 9230;

--[[

Commands:
	Listening to (9233<-):
		alive:
			request params: empty
			response params: empty
			
		reset:
			request params: empty
			response params: empty
		status:
			request params: empty
			response params: status (string)
		test:
			request params: empty
			response params: empty
]]--

debug = false

function processUdpCommand(obj)
	local cmd = obj.command_name;

	if cmd=="alive" then
		--Ack the request
  		return {
  			command_name="alive"
  		};
	end
	if cmd=="reset" then
  		--restart in 3 seconds
  		resetTimer = uv.new_timer();
  		resetTimer:start(3000,0,function()
  			resetTimer:stop();
  			resetTimer:close();
  			os.execute("reboot");
  		end);

  		return {
  			command_name="reset"
  		};
	end
	if cmd=="status" then
		return {
			command_name="status",
			status="Alive"
		};
	end
	if cmd=="test" then

		local counter = 0;
		local lastState = true;
  		local testTimer = uv.new_timer();
  		testTimer:start(0,1000,function()
  			if counter>5 then
  				testTimer:stop();
  				testTimer:close();
  				os.execute("echo 0 > /dev/gpio/qino_status/value");
  				return;
  			end
  			if lastState then
  				os.execute("echo 1 > /dev/gpio/qino_status/value");
  			else
  				os.execute("echo 0 > /dev/gpio/qino_status/value");
  			end
  			lastState = not lastState;
  			counter = counter + 1;
  		end);

		return {
			command_name="test"
		};
	end
end

function main()
	biudp.initUdpServer(processUdpCommand, uv, BASE_NODE_PORT, "127.0.0.1", "127.0.0.1");
end

main();
while true do
	uv.run();
end