local json = require("json");

local module = {};

local BIND_ADDRESS = "127.0.0.1";
local NODE_ADDRESS = "127.0.0.1";

local BIND_PORT = 9232;

local UDP_TIMEOUT = 1000;
local UDP_RETRIES = 3;

local listeningTo = {};

local udpServer;

local function sendUdpResponse(obj, port)
  	udpServer:send(json.encode(obj), NODE_ADDRESS, port);
end

--Sends command "obj"
--Upon receiving response calls "callback" with object/nil when timeout
function module.sendUdpCommand(obj, port, callback)
	obj.uid = math.random(0,2000000000);
  	udpServer:send(json.encode(obj), NODE_ADDRESS, port);

  	local retries = 0;

  	local timeoutTimer = uv.new_timer();
  	timeoutTimer:start(UDP_TIMEOUT,UDP_TIMEOUT,function()
  		retries = retries+1;
  		if retries>3 then
  			--Timed out
  			if debug then
  				io.write("Command ",obj.uid);
  				io.write(" timed out!",'\n');
  				io.flush();
  			end
  			listeningTo[obj.uid] = nil;
		    timeoutTimer:stop();
		    timeoutTimer:close();
  			if callback~=nil then callback(nil); end
  			return;
  		end
  		--Resend
  		udpServer:send(json.encode(obj), NODE_ADDRESS, port);
  	end);

  	listeningTo[obj.uid] = {
  		timer=timeoutTimer,
  		callback=callback
	};
end

function module.initUdpServer(cmdProcessor, luv, bindport, bindaddress, remoteaddress, timeout, retries)
	if luv==nil or cmdProcessor==nil then
		error("invalid parameters!");
	end

	uv = luv;
	if bindport~=nil then BIND_PORT=bindport; end
	if bindaddress~=nil then BIND_ADDRESS=bindaddress; end
	if remoteaddress~=nil then NODE_ADDRESS=remoteaddress; end
	if timeout~=nil then UDP_TIMEOUT=timeout; end
	if retries~=nil then UDP_RETRIES=retries; end

	math.randomseed(math.floor(os.clock()*1000000));

	udpServer = uv.new_udp();
  	udpServer:bind(BIND_ADDRESS,BIND_PORT);
  	udpServer:recv_start(function(err, data, address)
	    if data~=nil then
		    if debug then
		        io.write("[DEBUG] UDP received: ");
		        io.write(data);
		        io.write('\n');
		        io.flush();
		    end

			local obj = json.decode(data);
			if obj~=nil then

				--Check if it's some response
				local reqData = listeningTo[obj.uid];
				if reqData~=nil then
					--It's a response
	  				io.write("Response to command ",obj.uid);
	  				io.write(" received!",'\n');
	  				io.flush();
					listeningTo[obj.uid].timer:stop();
					listeningTo[obj.uid].timer:close();
					if listeningTo[obj.uid].callback~=nil then
						listeningTo[obj.uid].callback(obj);
					end
			  		listeningTo[obj.uid] = nil;
					return;
				end

				--Normal command
			    local resp = cmdProcessor(obj);
			    if resp~=nil then
			    	resp.uid = obj.uid;
			    	sendUdpResponse(resp,address.port);
			    else
			    	sendUdpResponse({
			    		command_name=obj.command_name,
			    		uid=obj.uid
			    	},address.port);
			    end

			end
		end
  	end);
end

return module;